<?php declare(strict_types=1);

namespace Surveys\AdminModule\Components\Question;


use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Surveys\Model\Entities\Question;
use Surveys\Model\Entities\Survey;
use Surveys\Model\Questions;
use Surveys\Model\Surveys;


class QuestionForm extends BaseControl
{
	/** @var Question */
	protected $question;

	/** @var Questions */
	protected $questionsService;

	/** @var Surveys */
	protected $surveysService;

	/** @var Survey */
	protected $survey;

	public function __construct(Questions $questionsService, Surveys $surveysService)
	{
		$this->questionsService = $questionsService;
		$this->surveysService = $surveysService;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addTextArea('question', 'surveys.questionForm.question')->setRequired();
		$form->addFilesManager('image', 'default.image');
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);
		$form->addTextArea('hint', 'surveys.questionForm.hint');
		$form->addText('class', 'surveys.questionForm.class');
		$form->addCheckbox('multipleAnswers', 'surveys.questionForm.multipleAnswers')->setDefaultValue(0);

		$form->addSaveCancelControl();

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->question) {
				$question = $this->question;
				$flashMessage = 'questions.categoriesForm.edited';
			} else {
				$question = new Question($values->question);
				$question->survey = $this->survey;
				$flashMessage = 'questions.categoriesForm.added';
			}

			$question->question = $values->question;
			$question->class = $values->class;
			$question->isPublished = $values->isPublished;
			$question->hint = $values->hint;
			$question->multipleAnswers = $values->multipleAnswers;

			$this->em->persist($question)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());
			return false;
		}

		return true;

	}

	public function setQuestion($id): void
	{
		$q = $this->question = $this->questionsService->get($id);

		if ($this->question) {
			$this['form']->setDefaults([
				'question' => $q->question,
				'isPublished' => $q->isPublished,
				'class' => $q->class,
				'hint' => $q->hint,
				'multipleAnswers' => $q->multipleAnswers,
			]);
		} else {
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
		}
	}

	public function setSurvey($id) {
		$this->survey = $this->surveysService->get($id);
		bdump($this->survey);
	}


}
