<?php declare(strict_types=1);

namespace Surveys\AdminModule\Components\Survey;


use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Questions\Model\Categories;
use Questions\Model\Entities\Category;
use Questions\Model\Entities\Question;
use Questions\Model\Questions;
use Surveys\Model\Entities\Survey;
use Surveys\Model\Surveys;

class SurveyForm extends BaseControl
{

	/** @var Survey */
	protected $survey;

	/** @var Surveys */
	protected $surveysService;

	public function __construct(Surveys $surveysService)
	{
		$this->surveysService = $surveysService;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('title', 'surveys.surveyForm.title')->setRequired();
		$form->addFilesManager('image', 'surveys.surveyForm.image');
		$form->addTextArea('description', 'surveys.surveyForm.description');
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);

		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			if ($this->survey) {
				$survey = $this->survey;
				$flashMessage = 'surveys.surveyForm.edited';
			} else {
				$survey = new Survey($values->title);
				$flashMessage = 'surveys.surveyForm.added';
			}

			$survey->title = $values->title;
			$survey->image = $values->image;
			$survey->description = $values->description;
			$survey->isPublished = $values->isPublished;

			$this->em->persist($survey)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}

		return true;

	}

	public function setSurvey($id)
	{
		$this->survey = $this->surveysService->get($id);

		if ($this->survey) {
			$form = $this['form'];
			$s = $this->survey;
			$form->setDefaults([
				'title' => $s->title,
				'description' => $s->description,
				'image' => $s->image,
				'isPublished' => $s->isPublished
			]);
		}
	}

	/*	public function setQuestion($id)
		{
			$this->question = $this->questionsService->get($id);

			if ($this->question) {
				$this['form']->setDefaults([
					'question'       => $this->question->question,
					'isPublished' => $this->question->isPublished,
					'score' => $this->question->score,
					'questionClass' => $this->question->questionClass,
					'hint' => $this->question->hint,
					'multipleAnswers' => $this->question->multipleAnswers,
					'category' => $this->question->groups[0]->getId()
				]);

			} else
				$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
		}*/


}
