<?php declare(strict_types = 1);

namespace Surveys\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;
use Surveys\Model\Entities\Question;

class Answer
{
	use MagicAccessors {
		__get as MA__get;
	}

	/** @var int */
	public $id;

	/** @var string */
	public $answer;

	/** @var string */
	public $image;

	/** @var bool */
	public $isPublished;

	/** @var float */
	public $score;

	/** @var string */
	public $class;

	/** @var Question */
	public $question;

	/** @var array */
	public $params;

	/**
	 * @param int $id
	 */
	public function setId(int $id): void
	{
		$this->id = $id;
	}

	/**
	 * @param string $answer
	 */
	public function setAnswer(string $answer): void
	{
		$this->answer = $answer;
	}

	/**
	 * @param string $image
	 */
	public function setImage(string $image): void
	{
		$this->image = $image;
	}

	/**
	 * @param bool $isPublished
	 */
	public function setIsPublished(bool $isPublished): void
	{
		$this->isPublished = $isPublished;
	}

	/**
	 * @param float $score
	 */
	public function setScore(float $score): void
	{
		$this->score = $score;
	}

	/**
	 * @param string $class
	 */
	public function setClass(string $class): void
	{
		$this->class = $class;
	}

	/**
	 * @param Question $question
	 */
	public function setQuestion(Question $question): void
	{
		$this->question = $question;
	}

	public function setParam($key, $value)
	{
		if ($value === null) {
			unset($this->params[$key]);
		} else {
			$this->params[$key] = $value;
		}
	}


	public function getParam($key)
	{
		return $this->params[$key] ?? null;
	}


	public function &__get($name)
	{
		return $this->params[$name] ?? $this->MA__get($name);
	}


}