<?php declare(strict_types = 1);

namespace Surveys\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;

class Question
{

	use MagicAccessors {
		__get as MA__get;
	}

	/** @var int */
	public $id;

	/** @var string */
	public $question;

	/** @var string */
	public $image;

	/** @var int */
	public $isPublished;

	/** @var float */
	public $score;

	/** @var string */
	public $class;

	/** @var string */
	public $hint;

	/** @var int */
	public $multipleAnswers;

	/** @var Answer[] */
	public $answers;

	/** @var Survey */

	/** @var array */
	public $params;


	/**
	 * @var int
	 */
	public $firstParentId;



	public function setId(int $id): Question
	{
		$this->id = $id;
		return $this;
	}


	public function setQuestion(string $question): Question
	{
		$this->question = $question;
		return $this;
	}


	public function setIsPublished(int $isPublished): Question
	{
		$this->isPublished = $isPublished;
		return $this;
	}

	/**
	 * @param string $hint
	 */
	public function setHint(string $hint): Question
	{
		$this->hint = $hint;
		return $this;
	}


	public function setScore(float $score): Question
	{
		$this->score = $score;
		return $this;
	}


	public function setClass($class)
	{
		$this->class = $class;
		return $this;
	}

	/**
	 * @param mixed $firstParent
	 */
	public function setFirstParent($firstParent): Question
	{
		$this->firstParent = $firstParent;
		return $this;
	}

	/**
	 * @param int $fistParentId
	 */
	public function setFirstParentId(int $fistParentId): Question
	{
		$this->firstParentId = $fistParentId;
		return $this;
	}


	public function setMultipleAnswers(int $multipleAnswers): Question
	{
		$this->multipleAnswers = $multipleAnswers;
		return $this;
	}


	public function setAnswers($answers): Question
	{
		$this->answers = $answers;
		return $this;
	}


	public function setGroups( $groups)
	{
		$this->groups = $groups;
		return $this;
	}

	public function &__get($name)
	{
		return $this->params[$name] ?? $this->MA__get($name);
	}


}