<?php declare(strict_types = 1);

namespace Surveys\FrontModule\Model\Dao;

use Kdyby\Doctrine\Entities\MagicAccessors;
use Questions\FrontModule\Model\Dao\Question;


class Survey
{
	use MagicAccessors {
		__get as MA__get;
	}

	/** @var int */
	public $id;

	/** @var string */
	public $title;

	/** @var string */
	public $image;

	/** @var string */
	public $description;

	/** @var Question[] */
	public $questions;

	/** @var bool */
	public $isPublished;

	/** @var array */
	public $params;

	/**
	 * @param int $id
	 */
	public function setId(int $id): void
	{
		$this->id = $id;
	}

	/**
	 * @param string $title
	 */
	public function setTitle(string $title): void
	{
		$this->title = $title;
	}

	/**
	 * @param string $image
	 */
	public function setImage(string $image): void
	{
		$this->image = $image;
	}

	/**
	 * @param string $description
	 */
	public function setDescription(string $description): void
	{
		$this->description = $description;
	}

	/**
	 * @param Question[] $questions
	 */
	public function setQuestions(array $questions): void
	{
		$this->questions = $questions;
	}

	/**
	 * @param bool $isPublished
	 */
	public function setIsPublished(bool $isPublished): void
	{
		$this->isPublished = $isPublished;
	}


	public function &__get($name)
	{
		return $this->params[$name] ?? $this->MA__get($name);
	}

	public function setParam($key, $value)
	{
		if ($value === null) {
			unset($this->params[$key]);
		} else {
			$this->params[$key] = $value;
		}
	}

	public function getParam($key)
	{
		return $this->params[$key] ?? null;
	}


}