<?php declare(strict_types = 1);

namespace Questions\FrontModule\Presenters;


use Nette\Application\Responses\JsonResponse;
use Questions\FrontModule\Model\Categories;
use Questions\FrontModule\Model\Dao\Answer;
use Questions\FrontModule\Model\Questions;
use Questions\FrontModule\Model\Answers;

final class DefaultPresenter extends BasePresenter
{
	/** @var Questions */
	protected $questionsService;

	/** @var Categories */
	protected $categoriesService;

	/** @var Answers */
	protected $answersService;

	public function __construct(Questions $questions, Categories $categories, Answers $answers)
	{
		$this->questionsService = $questions;
		$this->categoriesService = $categories;
		$this->answersService = $answers;
	}

	public function actionDefault()
	{
		$this->template->categories = $this->categoriesService->getAllByRootGroups(true);
	}

	public function handleGetQuestions()
	{
		$data = $this->categoriesService->getAllByRootGroups();
		$this->payload->data = $data;
		$this->sendPayload();
	}

	public function handleGetAnswers() {
		$data = $this->answersService->getAll();
		$this->payload->data = $data;
		$this->sendPayload();
	}

}