<?php declare(strict_types = 1);

namespace Surveys\Model;


use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use Surveys\Model\Entities\Answer;


class Answers extends BaseEntityService
{
	protected $entityClass = Answer::class;

	use TPublish;

	public function setPosition($id, $position)
	{
		if ($item = $this->get($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function voteOn($answerId)
	{
		if ($answer = $this->get($answerId)) {
			$answer->vote();
			$this->em->persist($answer);
			$this->em->flush();
		}
	}

}