<?php declare(strict_types = 1);

namespace Surveys\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="surveys__question")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class Question
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="question", type="string", length=1000, nullable=false)
	 */
	public $question;

	/**
	 * @var string
	 * @ORM\Column(name="image", type="string", length=255, nullable=true)
	 */
	public $image;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1}, nullable=false)
	 */
	public $isPublished;

	/**
	 * @var string
	 * @ORM\Column(name="hint", type="string", nullable=true)
	 */
	public $hint;

	/**
	 * @var string
	 * @ORM\Column(name="class", type="string", nullable=true)
	 */
	public $class;

	/**
	 * @var bool
	 * @ORM\Column(name="multiple_answers", type="smallint", options={"default:0"}, nullable=false)
	 */
	public $multipleAnswers;

	/**
	 * @var int
	 *
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	public $position;

	/**
	 * @var Answer[]
	 *
	 * @ORM\OneToMany(targetEntity="Answer", mappedBy="question")
	 */
	public $answers;

	/**
	 * @var Survey
	 * @ORM\ManyToOne(targetEntity="Survey", inversedBy="questions")
	 * @ORM\JoinColumn(name="survey_id", referencedColumnName="id")
	 */
	public $survey;

	/**
	 * @var array
	 * @ORM\Column(name="params", type="array", nullable=true)
	 */
	public $params;


	public function __construct($question)
	{
		$this->question = $question;
		$this->answers = new ArrayCollection();
		$this->params = [];
	}

	public function setParam($key, $value)
	{
		if ($value === null) {
			unset($this->params[$key]);
		} else {
			$this->params[$key] = $value;
		}
	}

	public function getParam($key)
	{
		return $this->params[$key] ?? null;
	}

	public function setPosition($position)
	{
		$this->position = $position;
	}

	public function getPosition(): int
	{
		return $this->position;
	}

}

