<?php declare(strict_types = 1);

namespace Surveys\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Gedmo\Mapping\Annotation as Gedmo;


/**
 * @ORM\Table(name="surveys__survey")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class Survey
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="answer", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var string
	 * @ORM\Column(name="image", type="string", length=255, nullable=true)
	 */
	public $image;

	/**
	 * @var string
	 * @ORM\Column(name="description", type="text", length=255, nullable=false)
	 */
	public $description;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1},nullable=false)
	 */
	public $isPublished;

	/**
	 * @var int
	 *
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	public $position;

	/**
	 * @var Question[]
	 *
	 * @ORM\OneToMany(targetEntity="Question", mappedBy="survey")
	 */
	public $questions;

	/**
	 * @var array
	 * @ORM\Column(name="params", type="array", nullable=true)
	 */
	public $params;

	public function __construct($title)
	{
		$this->title = $title;
		$this->isPublished = 1;
		$this->params = [];
	}

	public function setParam($key, $value)
	{
		if ($value === null) {
			unset($this->params[$key]);
		} else {
			$this->params[$key] = $value;
		}
	}

	public function getParam($key)
	{
		return $this->params[$key] ?? null;
	}

	public function setPosition($position)
	{
		$this->position = $position;
	}

	public function getPosition(): int
	{
		return $this->position;
	}




}