<?php declare(strict_types = 1);

namespace Surveys\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use Surveys\Model\Entities\Question;


class Questions extends BaseEntityService
{
	protected $entityClass = Question::class;

	use TPublish;

	public function setPosition($id, $position)
	{
		if ($item = $this->get($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function getVotesStatsInPercents($questionId)
	{
		$results = [];
		if ($question = $this->get($questionId)) {
			$answers = $question->answers;
			$sum = 0;
			foreach ($answers as $answer) {
				$sum += $answer->votes;
			}
			bdump($sum);
			foreach ($answers as $answer) {
				bdump($answer->votes);
				$results[$answer->id] = (100 / $sum) * $answer->votes;
			}
		}

		return $results;

	}

}