<?php declare(strict_types = 1);

namespace Surveys\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Surveys\Model\Surveys;
use Teams\Model\Groups;
use Teams\Model\Members;

class Survey extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'survey';

	/** @var Surveys */
	protected $surveysService;

	public function __construct(Surveys $surveys)
	{
		$this->surveysService = $surveys;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$surveys = ['' => ''];
		foreach ($this->surveysService->getEr()->findBy([], ['title' => 'ASC']) as $s) {
			$surveys[$s->getId()] = $s->title;
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $surveys);
	}

	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->surveysService->get($this->getDefault());
	}
}