<?php declare(strict_types = 1);

namespace Tags\AdminModule\Components;

use Blog\Model\UI;
use Core\Model\UI\BaseControl;
use Nette\Forms\Form;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use Tags\Model\Entities\Tag;

class TagForm extends BaseControl
{
	/** @var Tag */
	public $tag;

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);

		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[]           = [$this, 'formSuccess'];
		$form->onSuccess['redirect'] = function() {
			$this->getPresenter()->redirect('Default:');
		};

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values)
	{
		try {
			if ($this->tag) {
				$tag          = $this->tag;
				$flashMessage = 'tags.tagForm.edited';
			} else {
				$tag          = new Tag($values->title, $values->isPublished);
				$flashMessage = 'tags.tagForm.added';
			}

			$tag->title       = $values->title;
			$tag->isPublished = $values->isPublished;

			$this->em->persist($tag)->flush();
			$this->getPresenter()->flashMessageSuccess($flashMessage);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setTag($id)
	{
		$this->tag = $this->em->getRepository(Tag::class)->find($id);

		if ($this->tag) {
			$this['form']->setDefaults([
				'title'       => $this->tag->title,
				'isPublished' => $this->tag->isPublished,
			]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
