<?php declare(strict_types = 1);

namespace Tags\AdminModule\Components;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Tags\Model\Entities\Tag;
use Tags\Model\Tags;

class TagsGrid extends BaseControl
{
	/** @var Tags */
	protected $tagsService;

	public function __construct(Tags $tags)
	{
		$this->tagsService = $tags;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->tagsService->getEr()->createQueryBuilder('t');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('title', 'default.title', 'Default:edit');

		// Filter
		$grid->addFilterText('title', '');

		// Actions
		$grid->addAction('edit', '', 'Default:edit')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->addClass('ajax');


		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->tagsService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
}
