<?php declare(strict_types = 1);

namespace Tags\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="tag")
 * @ORM\Entity
 */
class Tag
{
	use TId;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255)
	 */
	public $title;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint")
	 */
	public $isPublished;

	public function __construct($title, $isPublished = 1)
	{
		$this->title       = $title;
		$this->isPublished = $isPublished;
	}

	public function setId($id)
	{
		$this->id = $id;
	}
}
