<?php declare(strict_types = 1);

namespace Tags\DI;

use Core\DI\CompilerExtension;

class TagsExtension extends CompilerExtension
{

	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Tags' => 'Tags\*Module\Presenters\*Presenter']);
	}
}
