<?php declare(strict_types = 1);

namespace Tags\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Nette\Caching\Cache;
use Tags\FrontModule\Model\Dao\Tag;

class Tags extends BaseFrontEntityService
{
	protected $entityClass = Tag::class;

	protected ?array $cAll = null;

	public function __construct(
		protected TagsCache $tagsCache,
	)
	{
	}

	/**
	 * @return Tag[]
	 */
	public function getByAll(): array
	{
		$key = $this->translator->getLocale();

		if ($this->cAll === null) {
			$this->cAll = $this->tagsCache->getCache()->load('all/' . $key, function(&$dep) {
				$dep[Cache::Expire] = '1 year';

				$result = [];
				foreach ($this->em->getConnection()->fetchAllAssociative("SELECT t.id, tt.title
					FROM tag t
					JOIN tag_text tt ON t.id = tt.tag_id AND tt.lang = :lang
				", [
					'lang' => $this->translator->getLocale(),
				]) as $row) {
					$id          = (int) $row['id'];
					$result[$id] = new Tag($id, $row['title']);
				}

				return $result;
			});
		}

		return $this->cAll;
	}
}
