<?php declare(strict_types = 1);

namespace Tags\FrontModule\Model;

use Core\Model\Lang\Langs;
use Nette\Caching\Cache;
use Nette\Caching\Storage;

class TagsCache
{
	public const cacheNamespace = 'pshkTagsNamespace';

	protected Cache $cache;

	public function __construct(
		protected Storage $storage,
		protected Langs   $langs,
	)
	{
		$this->cache = new Cache($storage, self::cacheNamespace);
	}

	public function getCache(): Cache
	{
		return $this->cache;
	}

	public function clearCache(): void
	{
		$cache = $this->getCache();

		foreach ($this->langs->getLangs(false) as $lang) {
			$cache->remove('all/' . $lang->getTag());
		}
	}

}
