<?php declare(strict_types = 1);

namespace Tags\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TranslateListener;
use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'tag')]
#[ORM\Entity]
#[ORM\EntityListeners([TranslateListener::class])]
class Tag
{
	use TId;
	use TTranslateListener;

	/**
	 * @deprecated
	 */
	#[ORM\Column(name: 'title', type: Types::STRING, length: 255)]
	public string $title;

	#[ORM\Column(name: 'is_published', type: Types::SMALLINT)]
	public int $isPublished = 1;

	/**
	 * @var Collection<TagText>
	 */
	#[ORM\OneToMany(targetEntity: TagText::class, mappedBy: 'tag', indexBy: 'lang')]
	public Collection $texts;

	public function __construct(string $title, int $isPublished = 1)
	{
		$this->title       = $title;
		$this->isPublished = $isPublished;
		$this->texts       = new ArrayCollection();
	}

	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

	public function getText(?string $lang = null): ?TagText
	{
		return $this->texts[$lang ?: $this->locale] ?? null;
	}
}
