<?php declare(strict_types = 1);

namespace Tags\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
#[ORM\Table(name: 'tag_text', indexes: [new ORM\Index(name: 'search_idx', columns: ['tag_id', 'lang'])])]
class TagText
{
	#[ORM\Id]
	#[ORM\ManyToOne(targetEntity: Tag::class, inversedBy: 'texts')]
	#[ORM\JoinColumn(name: 'tag_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
	protected Tag $tag;

	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, length: 2)]
	protected string $lang;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public ?string $title = null;

	public function __construct(Tag $tag, string $lang, ?string $title)
	{
		$this->tag   = $tag;
		$this->lang  = $lang;
		$this->title = $title;
	}
}
