<?php declare(strict_types = 1);

namespace Tags\Model;

use Contributte\Translation\Translator;
use Core\Model\Helpers\BaseEntityService;
use Exception;
use Tags\Model\Entities\Tag;

/**
 * @method Tag|null getReference(int $id)
 * @method Tag|null get(int $id)
 * @method Tag[] getAll()
 */
class Tags extends BaseEntityService
{
	protected $entityClass = Tag::class;

	public function __construct(
		protected Translator $translator,
	)
	{
	}

	/**
	 * @param string $title
	 */
	public function findByTitle($title): ?Tag
	{
		return $this->getEr()->findOneBy(['title' => $title]);
	}

	/**
	 * @return Tag[]
	 */
	public function getAvailableTags(): array
	{
		return $this->getEr()->findBy(['isPublished' => 1]);
	}

	/**
	 * @param string $title
	 *
	 * @return Tag[]
	 */
	public function filterAvailableTags($title): array
	{
		return $this->getEr()->findBy(['isPublished' => 1, 'title LIKE' => '%' . $title . '%']);
	}

	/**
	 * @param string $value
	 * @param int    $isPublished
	 */
	public function createTag($value, $isPublished = 1): bool|int
	{
		try {
			/** @var Tag|null $tag */
			$tag = $this->getEr()->findOneBy(['title' => $value]);

			if ($tag)
				$tag->isPublished = 1;
			else
				$tag = new Tag((string) $value, $isPublished);

			$this->em->persist($tag);
			$this->em->flush();

			return $tag->getId();
		} catch (Exception) {
		}

		return false;
	}

	/**
	 * @return array<int, string>
	 */
	public function getOptionsForSelect(): array
	{
		$qb = $this->getEr()->createQueryBuilder('t');
		$qb->select('t.id, tt.title')
			->join('t.texts', 'tt', 'WITH', 'tt.lang = :lang')
			->setParameter('lang', $this->translator->getLocale());

		$result = [];
		foreach ($qb->getQuery()->getArrayResult() as $row) {
			$result[$row['id']] = $row['title'];
		}

		return $result;
	}

}
