<?php declare(strict_types = 1);

namespace Tags\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use Tags\FrontModule\Model\TagsCache;
use Tags\Model\Entities\Tag;
use Tags\Model\Tags;

class TagsGrid extends BaseControl
{
	protected Tags $tagsService;
	protected TagsCache $tagsCache;

	public function __construct(
		Tags $tags,
		TagsCache $tagsCache
	)
	{
		$this->tagsService = $tags;
		$this->tagsCache = $tagsCache;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();

		$qb = $this->tagsService->getEr()->createQueryBuilder('t');
		$qb->addSelect('tt')
		   ->leftJoin('t.texts', 'tt', 'WITH', 'tt.lang = :lang')
		   ->setParameter('lang', $this->translator->getLocale());

		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('title', 'default.title', 'Default:edit')
			 ->setRenderer(static fn(Tag $tag) => $tag->getText() && $tag->getText()->title ? $tag->getText()->title : $tag->title);

		// Actions
		$grid->addAction('edit', '', 'Default:edit')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->addClass('ajax');

		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	/**
	 * @param string|int $id
	 */
	public function handleDelete($id): void
	{
		$presenter = $this->presenter;
		if ($this->tagsService->remove($id)) {
			$presenter->flashMessageSuccess('default.removed');
		} else {
			$presenter->flashMessageDanger('default.removeFailed');
		}

		$this->tagsCache->clearCache();

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else {
			$presenter->redirect('this');
		}
	}
}
