<?php declare(strict_types = 1);

namespace Tags\FrontModule\Model;

use Core\Model\Lang\Langs;
use Nette\Caching\Cache;
use Nette\Caching\Storage;

class TagsCache
{
	public const cacheNamespace = 'pshkTagsNamespace';

	protected Cache $cache;
	protected Langs $langs;

	public function __construct(
		Storage $storage,
		Langs $langs
	)
	{
		$this->cache = new Cache($storage, self::cacheNamespace);
		$this->langs = $langs;
	}

	public function getCache(): Cache
	{
		return $this->cache;
	}

	public function clearCache(): void
	{
		$cache = $this->getCache();

		foreach ($this->langs->getLangs(false) as $lang) {
			$cache->remove('all/' . $lang->getTag());
		}
	}

}