<?php declare(strict_types = 1);

namespace Tags\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="tag")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class Tag
{
	use TId;
	use TTranslateListener;

	/**
	 * @deprecated
	 * @ORM\Column(type="string", length=255)
	 */
	public string $title;

	/**
	 * @ORM\Column(type="smallint")
	 */
	public int $isPublished;

	/**
	 * @var Collection<TagText>
	 * @ORM\OneToMany(targetEntity="TagText", mappedBy="tag", indexBy="lang")
	 */
	public Collection $texts;

	public function __construct(string $title, int $isPublished = 1)
	{
		$this->title       = $title;
		$this->isPublished = $isPublished;
		$this->texts       = new ArrayCollection;
	}

	public function setId(?int $id): void
	{
		$this->id = $id;
	}
	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);
		return $this;
	}

	public function getText(?string $lang = null): ?TagText
	{
		return $this->texts[$lang ?: $this->locale] ?? null;
	}

}