<?php declare(strict_types = 1);

namespace Tags\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="tag_text", indexes={@ORM\Index(name="search_idx", columns={"tag_id", "lang"})})
 * @ORM\Entity
 */
class TagText
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Tag", inversedBy="texts")
	 * @ORM\JoinColumn(name="tag_id", referencedColumnName="id", onDelete="CASCADE", nullable=false)
	 */
	protected Tag $tag;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2, nullable=false)
	 */
	protected string $lang;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $title = null;

	public function __construct(Tag $tag, string $lang, ?string $title)
	{
		$this->tag   = $tag;
		$this->lang  = $lang;
		$this->title = $title;
	}

}