<?php declare(strict_types = 1);

namespace Tags\Model;

use Core\Model\Helpers\BaseEntityService;
use Contributte\Translation\Translator;
use Tags\Model\Entities\Tag;

/**
 * @method Tag|null getReference(int $id)
 * @method Tag|null get(int $id)
 * @method Tag[] getAll()
 */
class Tags extends BaseEntityService
{
	protected $entityClass = Tag::class;
	protected Translator $translator;

	public function __construct(Translator $translator)
	{
		$this->translator = $translator;
	}

	/**
	 * @param string $title
	 * @return Tag|null
	 */
	public function findByTitle($title)
	{
		return $this->getEr()->findOneBy(['title' => $title]);
	}

	/**
	 * @return Tag[]
	 */
	public function getAvailableTags(): array
	{
		return $this->getEr()->findBy(['isPublished' => 1]);
	}

	/**
	 * @param string $title
	 * @return Tag[]
	 */
	public function filterAvailableTags($title): array
	{
		return $this->getEr()->findBy(['isPublished' => 1, 'title LIKE' => '%' . $title . '%']);
	}

	/**
	 * @param string $value
	 * @param int    $isPublished
	 *
	 * @return bool|int
	 */
	public function createTag($value, $isPublished = 1)
	{
		try {
			/** @var Tag|null $tag */
			$tag = $this->getEr()->findOneBy(['title' => $value]);

			if ($tag)
				$tag->isPublished = 1;
			else
				$tag = new Tag($value, $isPublished);

			$this->em->persist($tag);
			$this->em->flush();

			return $tag->getId();
		} catch (\Exception $e) {
		}

		return false;
	}

	/**
	 * @return array<int, string>
	 */
	public function getOptionsForSelect(): array
	{
		$qb = $this->getEr()->createQueryBuilder('t');
		$qb->select('t.id, tt.title')
		   ->join('t.texts', 'tt', 'WITH', 'tt.lang = :lang')
		   ->setParameter('lang', $this->translator->getLocale());

		$result = [];
		foreach ($qb->getQuery()->getArrayResult() as $row) {
			$result[$row['id']] = $row['title'];
		}

		return $result;
	}

}