<?php declare(strict_types = 1);

namespace Tags\AdminModule\Components;

use Blog\Model\UI;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Exception;
use Nette\Forms\Form;
use Nette\Utils\ArrayHash;
use Tags\Model\Entities\Tag;

class TagForm extends BaseControl
{
	/** @var Tag|null */
	public $tag;

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'default.isPublished')->setDefaultValue(1);

		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[]           = $this->formSuccess(...);
		$form->onSuccess['redirect'] = function(): never {
			$this->presenter->redirect('Default:');
		};

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values): void
	{
		try {
			if ($this->tag) {
				$tag          = $this->tag;
				$flashMessage = 'tags.tagForm.edited';
			} else {
				$tag          = new Tag((string) $values->title, $values->isPublished);
				$flashMessage = 'tags.tagForm.added';
			}

			$tag->title       = $values->title;
			$tag->isPublished = $values->isPublished;

			$this->em->persist($tag)->flush();
			$this->presenter->flashMessageSuccess($flashMessage);
		} catch (Exception $e) {
			$form->addError($e->getMessage());
		}
	}

	public function setTag(string|int $id): void
	{
		$this->tag = $this->em->getRepository(Tag::class)->find($id);

		if ($this->tag) {
			$this['form']->setDefaults([
				'title'       => $this->tag->title,
				'isPublished' => $this->tag->isPublished,
			]);
		} else {
			$this->presenter->error();
		}
	}
}
