<?php declare(strict_types = 1);

namespace Tags\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use Tags\Model\Tags;

class TagsGrid extends BaseControl
{
	public function __construct(protected Tags $tagsService)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();

		$qb = $this->tagsService->getEr()->createQueryBuilder('t');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('title', 'default.title', 'Default:edit');

		// Filter
		$grid->addFilterText('title', '');

		// Actions
		$grid->addAction('edit', '', 'Default:edit')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->addClass('ajax');

		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */
	public function handleDelete(string|int $id): void
	{
		$presenter = $this->presenter;
		if ($this->tagsService->remove($id)) {
			$presenter->flashMessageSuccess('default.removed');
		} else {
			$presenter->flashMessageDanger('default.removeFailed');
		}

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else {
			$presenter->redirect('this');
		}
	}
}
