<?php declare(strict_types = 1);

namespace Tags\AdminModule\Presenters;

use Tags\AdminModule\Components\ITagFormFactory;
use Tags\AdminModule\Components\ITagsGridFactory;
use Tags\AdminModule\Components\TagForm;
use Tags\AdminModule\Components\TagsGrid;
use Tags\Model\Entities\Tag;

final class DefaultPresenter extends BasePresenter
{
	protected function startup(): void
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('tags.title.tags'));
		$this->setHeader('tags.title.tags', 'fa fa-tags');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this['navigation']->setData(['header' => [
			[
				//TODO popup
				'title' => 'tags.menu.addTag',
				'link'  => 'Default:add',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAdd(): void
	{
		$this->setTitle($this->translator->translate('tags.title.addTag'));
		$this->setHeader('tags.title.addTag', 'fa fa-tags');
	}

	public function actionEdit(string|int $id): void
	{
		$tag = $this->em->getRepository(Tag::class)->find($id);

		if (!$tag)
			$this->error();

		$this->setTitle($this->translator->translate('tags.title.editTag'), $tag->title);
		$this->setHeader('tags.title.editTag', 'fa fa-tags');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentTagsGrid(ITagsGridFactory $factory): TagsGrid
	{
		return $factory->create();
	}

	protected function createComponentTagForm(ITagFormFactory $factory): TagForm
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setTag($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function(): never {
			$this->redirect('default');
		};

		return $control;
	}
}
