<?php declare(strict_types = 1);

namespace Tags\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'tag')]
#[ORM\Entity]
class Tag
{
	use TId;

	#[ORM\Column(name: 'title', type: Types::STRING, length: 255)]
	public string $title;

	#[ORM\Column(name: 'is_published', type: Types::SMALLINT)]
	public int $isPublished = 1;

	public function __construct(string $title, int $isPublished = 1)
	{
		$this->title       = $title;
		$this->isPublished = $isPublished;
	}
}
