<?php declare(strict_types = 1);

namespace Tags\Model;

use Core\Model\Helpers\BaseEntityService;
use Exception;
use Tags\Model\Entities\Tag;

/**
 * Class Tags
 * @package Tags\Model
 *
 * @method Tag|object|null getReference($id)
 * @method Tag[]|null getAll()
 * @method Tag|null get($id)
 */
class Tags extends BaseEntityService
{
	protected $entityClass = Tag::class;

	/**
	 * @param string $title
	 */
	public function findByTitle($title): ?Tag
	{
		return $this->getEr()->findOneBy(['title' => $title]);
	}

	/**
	 * @return Tag[]
	 */
	public function getAvailableTags(): array
	{
		return $this->getEr()->findBy(['isPublished' => 1]);
	}

	/**
	 * @param string $title
	 *
	 * @return Tag[]
	 */
	public function filterAvailableTags($title): array
	{
		return $this->getEr()->findBy(['isPublished' => 1, 'title LIKE' => '%' . $title . '%']);
	}

	/**
	 * @param string $value
	 * @param int    $isPublished
	 */
	public function createTag($value, $isPublished = 1): bool|int
	{
		try {
			/** @var Tag|null $tag */
			$tag = $this->getEr()->findOneBy(['title' => $value]);

			if ($tag)
				$tag->isPublished = 1;
			else
				$tag = new Tag((string) $value, $isPublished);

			$this->em->persist($tag);
			$this->em->flush();

			return $tag->getId();
		} catch (Exception) {
		}

		return false;
	}
}
