<?php declare(strict_types = 1);

namespace Tags\Model;

use Core\Model\Helpers\BaseEntityService;
use Tags\Model\Entities\Tag;

/**
 * Class Tags
 * @package Tags\Model
 *
 * @method Tag|object|null getReference($id)
 * @method Tag[]|null getAll()
 * @method Tag|null get($id)
 */
class Tags extends BaseEntityService
{
	protected $entityClass = Tag::class;

	/**
	 * @param $title
	 *
	 * @return Tag|null|object
	 */
	public function findByTitle($title)
	{
		return $this->getEr()->findOneBy(['title' => $title]);
	}

	/**
	 * @return Tag[]|null
	 */
	public function getAvailableTags()
	{
		return $this->getEr()->findBy(['isPublished' => 1]);
	}

	/**
	 * @param $title
	 *
	 * @return Tag[]|null
	 */
	public function filterAvailableTags($title)
	{
		return $this->getEr()->findBy(['isPublished' => 1, 'title LIKE' => '%' . $title . '%']);
	}

	/**
	 * @param string $value
	 * @param int    $isPublished
	 *
	 * @return bool|int
	 */
	public function createTag($value, $isPublished = 1)
	{
		try {
			if ($tag = $this->getEr()->findOneBy(['title' => $value]))
				$tag->isPublished = 1;
			else
				$tag = new Tag($value, $isPublished);

			$this->em->persist($tag);
			$this->em->flush();

			return $tag->getId();
		} catch (\Exception $e) {
		}

		return false;
	}
}