<?php declare(strict_types=1);

namespace Teams\Model;

use Core\Model\Helpers\Arrays;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use Core\Model\Entities\Repository\NestedTreeRepository;
use Teams\Model\Entities\Group;

/**
 * Class Groups
 * @package Group\Model
 *
 * @method Group|object|null getReference($id)
 * @method Group[]|null getAll()
 * @method Group|null get($id)
 * @method NestedTreeRepository getEr()
 */
class Groups extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Group::class;
}