<?php declare(strict_types = 1);

namespace Teams\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Teams\Model\Groups;
use Teams\Model\Members;

class TeamsGroup extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'teamsByGroup';

	/** @var Members */
	protected $membersService;

	/** @var Groups */
	protected $groupsService;

	public function __construct(Members $members, Groups $groups)
	{
		$this->membersService = $members;
		$this->groupsService  = $groups;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$groups = ['' => ''];
		foreach ($this->groupsService->getEr()->findBy([], ['title' => 'ASC']) as $g) {
			$groups[$g->getId()] = $g->title;
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $groups);
	}

	public function render($params)
	{
		if (!isset($params['toVar'])) {
			throw new InvalidArgumentException('Need variable for output');
		}

		return $this->membersService->getPublishedByGroup($this->getDefault());
	}
}