<?php declare(strict_types = 1);

namespace Teams\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Teams\AdminModule\Components\IGroupFormFactory;
use Teams\AdminModule\Components\IGroupsGridFactory;
use Teams\AdminModule\Components\IMemberFormFactory;
use Teams\AdminModule\Components\IMembersGridFactory;
use Teams\Model\Entities\Group;
use Teams\Model\Entities\Member;

final class DefaultPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('teams.title.teams'));
		$this->setHeader('teams.title.teams', 'fa fa-users');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'teams.menu.addMember',
				'link'  => 'Default:addMember',
				'ico'   => 'plus',
			], [
				'title' => 'teams.menu.addGroup',
				'link'  => 'Default:addGroup',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAddGroup()
	{
		$this->setTitle($this->translator->translate('teams.title.addGroup'));
		$this->setHeader('teams.title.addGroup', 'fa fa-users');
	}

	public function actionAddMember()
	{
		$this->setTitle($this->translator->translate('teams.title.addMember'));
		$this->setHeader('teams.title.addMember', 'fa fa-users');
	}

	public function actionEditGroup($id)
	{
		$group = $this->em->getRepository(Group::class)->find($id);

		if (!$group)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('teams.title.editGroup'), $group->title);
		$this->setHeader('teams.title.editGroup', 'fa fa-users');
	}

	public function actionEditMember($id)
	{
		$member = $this->em->getRepository(Member::class)->find($id);

		if (!$member)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('teams.title.editMember'), $member->title);
		$this->setHeader('teams.title.editMember', 'fa fa-users');
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentGroupsGrid(IGroupsGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentGroupForm(IGroupFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setGroup($this->getParameter('id'));

		$control['form']->onSuccess['redirect'] = function() {
			$this->redirect('default');
		};

		return $control;
	}

	protected function createComponentMembersGrid(IMembersGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentMemberForm(IMemberFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setEntity($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('editMember', $form->getCustomData('memberId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('default');
		};

		return $control;
	}
}