<?php declare(strict_types = 1);

namespace Teams\FrontModule\Model\Subscribers;

use Contributte\EventDispatcher\EventSubscriber;
use Core\Model\Event\TtSearchEvent;
use Kdyby\Doctrine\EntityManager;
use Teams\Model\Members;

class TtSearchSubscriber implements EventSubscriber
{
	/** @var EntityManager */
	protected $em;

	/** @var Members */
	protected $members;

	public function __construct(EntityManager $em, Members $members)
	{
		$this->em      = $em;
		$this->members = $members;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'core.searching.deep' => 'search',
		];
	}

	public function search(TtSearchEvent $event): void
	{
		$result   = [];
		$groupIds = [];
		foreach ($event->inputs as $row) {
			if (in_array($row['type'], ['teamsByGroup'])) {
				$id            = $event->values[$row['name']];
				$groupIds[$id] = $id;
			}
		}

		if (empty($groupIds))
			return;

		$qb = $this->members->getEr()->createQueryBuilder('m')
			->select('g.id as group, m.id, m.title, m.position, m.texts')
			->join('m.groups', 'g', 'WITH', 'g.id IN (:groups)')
			->andWhere('m.isPublished = 1')
			->setParameter('groups', array_values($groupIds))
			->groupBy('m.id');

		$q = $event->q;
		$qb->andWhere('m.title LIKE :q OR m.texts LIKE :q')
			->setParameter('q', "%$q%");
		//		$k = 0;
		//		foreach (explode(' ', $event->q) as $k => $q) {
		//		$qb->orWhere("m.title LIKE :q$k OR m.texts LIKE :q$k")
		//			->setParameter("q$k", "%$q%");
		//		}

		foreach ($qb->getQuery()->getArrayResult() as $row) {
			$result[$row['group']][$row['id']] = [
				'title' => $row['title'],
				'texts' => $row['texts'],
			];
		}

		if (!empty($result))
			$event->addResult('teamsByGroup', $result);
	}
}
