<?php declare(strict_types = 1);

namespace Teams\Model\Entities;

use Core\Model\Entities\TId;
use Core\Model\Entities\TLang;
use Core\Model\TemplateReader\Entity\ITemplate;
use Core\Model\TemplateReader\Entity\TTemplate;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Nette\Utils\Validators;

/**
 * @ORM\Table(name="teams__member")
 * @ORM\Entity(repositoryClass="Core\Model\Entities\Repository\SortableRepository")
 */
class Member implements ITemplate
{
	use TId;
	use TTemplate;
	use TLang;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default":1})
	 */
	public $isPublished;

	/**
	 * @var int
	 *
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	public $position;

	/**
	 * @var Group[]
	 *
	 * @ORM\ManyToMany(targetEntity="Group", inversedBy="members")
	 * @ORM\JoinTable(name="teams__group_members",
	 *  joinColumns={@ORM\JoinColumn(name="member_id", referencedColumnName="id")},
	 *  inverseJoinColumns={@ORM\JoinColumn(name="group_id", referencedColumnName="id")})
	 */
	public $groups;

	/**
	 * Member constructor.
	 *
	 * @param $title
	 * @param $template
	 */
	public function __construct($title, $template)
	{
		$this->title       = $title;
		$this->template    = $template;
		$this->isPublished = 1;
		$this->groups      = new ArrayCollection();
		$this->texts       = [];
		$this->setPosition(-1);
	}

	/*****
	 * === Position
	 */

	public function setPosition($position)
	{
		$this->position = intval($position);
	}

	/*****
	 * === Groups
	 */

	public function setGroups(array $groups)
	{
		$this->groups = new ArrayCollection($groups);
	}
}
