<?php declare(strict_types = 1);

namespace Teams\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use Teams\Model\Entities\Member;

/**
 * Class Members
 * @package Members\Model
 *
 * @method Member|object|null getReference($id)
 * @method Member[]|null getAll()
 * @method Member|null get($id)
 */
class Members extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Member::class;

	/**
	 * @return string
	 */
	public function getTemplatesDir()
	{
		return TEMPLATES_DIR . '/Front/default/Teams/TemplateMember';
	}

	/**
	 * @param $groupId
	 *
	 * @return Member[]|null
	 */
	public function getPublishedByGroup($groupId)
	{
		return $this->getEr()->createQueryBuilder('m', 'm.id')->where('m.isPublished = 1')
			->innerJoin('m.groups', 'g')->andWhere('g.id = :groupId')->andWhere('g.isPublished = 1')
			->setParameter('groupId', $groupId)->orderBy('m.position', 'ASC')->getQuery()->getResult();
	}

	public function setPosition($id, $position)
	{
		if ($item = $this->get($id)) {
			$item->setPosition($position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}
}