<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20180801010102 extends AbstractMigration
{
	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE teams__group (id INT AUTO_INCREMENT NOT NULL, parent_id INT DEFAULT NULL, tree_root INT DEFAULT NULL, title VARCHAR(255) NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, lft INT NOT NULL, lvl INT NOT NULL, rgt INT NOT NULL, INDEX IDX_4F6B49F4727ACA70 (parent_id), INDEX IDX_4F6B49F4A977936C (tree_root), PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE teams__member (id INT AUTO_INCREMENT NOT NULL, first_name VARCHAR(255) NOT NULL, last_name VARCHAR(255) NOT NULL, positions VARCHAR(255) DEFAULT NULL, street VARCHAR(255) DEFAULT NULL, city VARCHAR(255) DEFAULT NULL, zip VARCHAR(8) DEFAULT NULL, phone VARCHAR(255) DEFAULT NULL, email VARCHAR(60) DEFAULT NULL, image VARCHAR(255) DEFAULT NULL, text LONGTEXT DEFAULT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, social_links LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', params LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:array)\', PRIMARY KEY(id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE teams__group_members (member_id INT NOT NULL, group_id INT NOT NULL, INDEX IDX_23CA29997597D3FE (member_id), INDEX IDX_23CA2999FE54D947 (group_id), PRIMARY KEY(member_id, group_id)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');

		$this->addSql('ALTER TABLE teams__group ADD CONSTRAINT FK_4F6B49F4727ACA70 FOREIGN KEY (parent_id) REFERENCES teams__group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE teams__group ADD CONSTRAINT FK_4F6B49F4A977936C FOREIGN KEY (tree_root) REFERENCES teams__group (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE teams__group_members ADD CONSTRAINT FK_23CA29997597D3FE FOREIGN KEY (member_id) REFERENCES teams__member (id)');
		$this->addSql('ALTER TABLE teams__group_members ADD CONSTRAINT FK_23CA2999FE54D947 FOREIGN KEY (group_id) REFERENCES teams__group (id)');
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('ALTER TABLE teams__group DROP FOREIGN KEY FK_4F6B49F4727ACA70');
		$this->addSql('ALTER TABLE teams__group DROP FOREIGN KEY FK_4F6B49F4A977936C');
		$this->addSql('ALTER TABLE teams__group_members DROP FOREIGN KEY FK_23CA2999FE54D947');
		$this->addSql('ALTER TABLE teams__group_members DROP FOREIGN KEY FK_23CA29997597D3FE');

		$this->addSql('DROP TABLE teams__group');
		$this->addSql('DROP TABLE teams__member');
		$this->addSql('DROP TABLE teams__group_members');
	}
}
