import Alpine from 'alpinejs'

window.Alpine = Alpine

document.addEventListener('alpine:init', () => {
	const startingWith = (subject, replacement) => ({ name, value }) => {
		if (name.startsWith(subject)) {
			name = name.replace(subject, replacement);
		}
		return { name, value };
	};

	Alpine.prefix('data-x-');
	Alpine.mapAttributes(startingWith('data-x-on.', Alpine.prefixed('on:')));
	Alpine.mapAttributes(startingWith('data-x-bind.', Alpine.prefixed('bind:')));
	Alpine.mapAttributes(startingWith('data-x-transition.', Alpine.prefixed('transition:')));

	Alpine.directive('slide-up-down', (el, { expression }, { evaluate }) => { 
		el.setAttribute("data-x-transition.enter", "transition-all ease-out duration-" + expression); 
		el.setAttribute("data-x-transition.enter-start", "grid-rows-[0fr]"); 
		el.setAttribute("data-x-transition.enter-end", "grid-rows-[1fr]"); 
		el.setAttribute("data-x-transition.leave", "transition-all ease-out duration-" + expression); 
		el.setAttribute("data-x-transition.leave-start", "grid-rows-[1fr]"); 
		el.setAttribute("data-x-transition.leave-end", "grid-rows-[0fr]");
	});
	
	Alpine.directive('opacity', (el, { expression }, { evaluate }) => { 
		el.setAttribute("data-x-transition.enter", "transition-all ease-in-out duration-" + expression); 
		el.setAttribute("data-x-transition.enter-start", "opacity-0"); 
		el.setAttribute("data-x-transition.enter-end", "opacity-100"); 
		el.setAttribute("data-x-transition.leave", "transition-all ease-in-out duration-" + expression); 
		el.setAttribute("data-x-transition.leave-start", "opacity-100"); 
		el.setAttribute("data-x-transition.leave-end", "opacity-0");
	});

	Alpine.store({
		burgerOpen: false,
	});
})

Alpine.start()