import { Carousel } from "@fancyapps/ui/dist/carousel/";
import { Arrows } from "@fancyapps/ui/dist/carousel/carousel.arrows.js";
import { Autoplay } from "@fancyapps/ui/dist/carousel/carousel.autoplay.js";
import { Dots } from "@fancyapps/ui/dist/carousel/carousel.dots.js";


// Wait for Alpine to be ready
document.addEventListener('alpine:init', () => {
    // Register the directive without x- prefix
    window.Alpine.directive('carousel', (el, { expression }) => {
        let options = {};
        let carousel = null;
        
        // Parse options if provided
        if (expression) {
            try {
                options = new Function('return ' + expression)();
            } catch (e) {
                console.warn('Failed to parse carousel options');
            }
        }

				let customOptions = {};
				if (options?.custom) {
					customOptions = { ...options.custom };
					delete options.custom;
				}

        // Set default arrows (navigation) if not provided
        if (options.Arrows !== false && !options.Arrows?.prevTpl && !options.Arrows?.nextTpl) {
            options.Arrows = {
                prevTpl:
                    '<svg xmlns="http://www.w3.org/2000/svg" width="29" height="54" viewBox="0 0 29 54" fill="none"><path d="M28 53L2 27L28 1"/></svg>',
                nextTpl:
                    '<svg xmlns="http://www.w3.org/2000/svg" width="29" height="54" viewBox="0 0 29 54" fill="none"><path d="M1 0.999998L27 27L1 53"/></svg>',
            };
        }

        // Set default transition
        if (!options.transition) {
            options.transition = "slide";
        }

        // Set default options safely
        options.on = options.on || {};

        // Add ready handler if not present
        /* if (!options.on.ready) {
            options.on.ready = carousel => {
                if (carousel?.container) {
                    carousel.container.classList.add('f-carousel--ready');
                }
            };
        } */
		  
        try {
            carousel = Carousel(el, options, { Arrows, Autoplay, Dots }).init();
        } catch (error) {
            console.warn('Failed to initialize carousel');
        }

        // Return cleanup function
        return () => {
            if (carousel) {
                carousel.destroy();
                carousel = null;
            }
        };
    });
});