
const items = document.querySelectorAll('[data-pagination]');

const prev = document.querySelector('[data-pagination-prev]');
const next = document.querySelector('[data-pagination-next]');

const pageSize = referencesPageSize || 6;

prev.addEventListener('click', e => {
	let referencesPage = localStorage.getItem('referencesPage');

	localStorage.setItem('referencesPage', parseInt(referencesPage) - pageSize);
	checkItems();
	window.scrollTo(0, 0);
})
next.addEventListener('click', e => {
	let referencesPage = localStorage.getItem('referencesPage');
	
	localStorage.setItem('referencesPage', parseInt(referencesPage) + pageSize);
	checkItems();
	window.scrollTo(0, 0);
})

const checkItems = () => {
	items.forEach(item => {
		item.classList.remove('flex');
		item.classList.add('hidden');
	})

	let referencesPage = localStorage.getItem('referencesPage');

	if (parseInt(referencesPage) < pageSize) {
		prev.classList.add('hidden');
		prev.classList.remove('flex');
	}
	else {
		prev.classList.remove('hidden');
		prev.classList.add('flex');
	}

	if (parseInt(referencesPage) + pageSize >= items.length) {
		next.classList.add('hidden');
		next.classList.remove('flex');
	}
	else {
		next.classList.remove('hidden');
		next.classList.add('flex');
	}


	items.forEach(item => {
		let referencesPage = localStorage.getItem('referencesPage');
		let itemPagination = parseInt(item.dataset.pagination);

		if (itemPagination > parseInt(referencesPage) && itemPagination <= parseInt(referencesPage) + pageSize) {
			item.classList.add('flex');
			item.classList.remove('hidden');
		}
	})
}



if (localStorage.getItem('previousUrl').indexOf(window.location.pathname) !== -1) {
	console.log('z referencei asd');

}
else {
	localStorage.setItem('referencesPage', 0);
}

checkItems();