import {slideUp, slideDown} from 'es6-slide-up-down';
const containers = document.querySelectorAll('[data-slide-container]');

containers.forEach(container => {
	const control = container.querySelector('[data-slide-control]');
	const content = container.querySelector('[data-slide-target]');

	if (control && content) {
		control.addEventListener('click', e => {
			e.stopPropagation();
			e.stopImmediatePropagation();
			if (content.classList.contains('slide-active')) {
				content.classList.remove('slide-active');
				control.classList.remove('scaleY-1--active');
				slideUp(content, 150);
			}
			else {
				content.classList.add('slide-active');
				control.classList.add('scaleY-1--active');
				slideDown(content, 150);
			}
		})
	}
})