export default class GoogleMap {
	constructor(apiKey, callback, afterMapLoad = [], initImmediately = true) {
		this.apiKey = apiKey;
		this.callback = callback;
		this.afterMapLoad = afterMapLoad;
		if (initImmediately) this.init();
	}
	init() {
		window.afterMapLoad = this.afterMapLoad;
		let scriptTag = document.createElement('script');
		scriptTag.setAttribute("type", "text/javascript");
		scriptTag.setAttribute("src", `https://maps.googleapis.com/maps/api/js?key=${this.apiKey}`);
		if (scriptTag.readyState) {
			scriptTag.onreadystatechange = function () {
				if (scriptTag.readyState === "loaded" || scriptTag.readyState === "complete") {
					scriptTag.onreadystatechange = null;
					this.callback()
				}
			};
		} else {
			scriptTag.onload = () => {
				this.callback();
				window.afterMapLoad.forEach(c => c());
			};
		}
		(document.getElementsByTagName("head")[0] || document.documentElement).appendChild(scriptTag);
	}
}
