import {slideUp, slideDown} from 'es6-slide-up-down';
const hamburger = (
	hamburgerIcon = document.getElementById('hamburger'),
	responsiveMenu = document.querySelector('.mobile-navigation'),
	submenuControls = document.querySelectorAll('[data-submenu-control]'),
) => {
	if (hamburgerIcon) {
		document.addEventListener("click", (e) => {
			if (responsiveMenu.style.display === 'block' && e.target.closest('#hamburger') === null && e.target.closest('[data-submenu-control]') == null) {
				slideUp(responsiveMenu);
				responsiveMenu.classList.remove('active');
				hamburgerIcon.classList.remove('hamburger--active');
			}
		}, false);
		hamburgerIcon.addEventListener('click', () => {
			
			if (!responsiveMenu.classList.contains('active')) {
				slideDown(responsiveMenu, 200);
				responsiveMenu.classList.add('active');
				hamburgerIcon.classList.add('hamburger--active');
			} else {
				slideUp(responsiveMenu, 200);
				responsiveMenu.classList.remove('active');
				hamburgerIcon.classList.remove('hamburger--active');
			}
		});

		submenuControls.forEach(submenuControl => {
			submenuControl.addEventListener('click', e => {
				e.preventDefault();
				const submenuContainer = submenuControl.closest('[data-submenu-container]');
				const submenuTarget = submenuContainer.querySelector('[data-submenu-target]');
				if (submenuTarget) {
					if (!submenuTarget.classList.contains('active')) {
						slideDown(submenuTarget, 200);
						submenuTarget.classList.add('active');
						submenuControl.classList.add('active');
					}
					else {
						slideUp(submenuTarget, 200);
						submenuTarget.classList.remove('active');
						submenuControl.classList.remove('active');
					}
				}
			})
		})


	}
}

export default hamburger;