const isVisible = e => {
	return !!( e.offsetWidth || e.offsetHeight || e.getClientRects().length );
}


const headerScrollCheck = (
	breakpoint = 70, 
	topPanel = document.querySelector('.topPanel'), 
	navList = document.querySelector('.navigation__list'), 
	hamburger = document.querySelector('#hamburger')
	) => {
	document.addEventListener('scroll', e => {
		if (window.pageYOffset >= breakpoint) {
			topPanel.classList.add('active');
			navList.classList.add('navigation__list--scroll');
		}
		else {
			if (!isVisible(hamburger)) 
				topPanel.classList.remove('active');
			navList.classList.remove('navigation__list--scroll');
		}
	});

	document.addEventListener("DOMContentLoaded", () => {
		if (window.pageYOffset >= breakpoint) {
			topPanel.classList.add('active');
			navList.classList.add('navigation__list--scroll');
		}
		else {
			if (!isVisible(hamburger)) 
				topPanel.classList.remove('active');
			navList.classList.remove('navigation__list--scroll');
		}
	});
}
 
export default headerScrollCheck;