const Nette = window.Nette;

let script = document.createElement("script");
script.setAttribute("src", "https://www.google.com/recaptcha/api.js?render=explicit");

const initializeRecaptcha = (e) => {
	document.removeEventListener("click", initializeRecaptcha);

	document.body.appendChild(script);

	const scriptLoaded = (e) => {
		(function(document, Nette, grecaptcha) {
			let init = false;
			let gToken = null;

			Nette.recaptcha = function(grecaptcha) {
				const items = document.getElementsByClassName("g-recaptcha");
				const length = items.length;

				if (length > 0) {
					grecaptcha.ready(function() {
						for (let i = 0; i < length; i++) {
							let item = items[i];
							grecaptcha.render(item, {
								callback: function(token) {
									gToken = token;
								},
							});
						}
								
						let isRecaptchaInvisible = true;
						if (!document.querySelector(".grecaptcha-badge")) {
							isRecaptchaInvisible = false;
						}

						global.naja.addEventListener("complete", (e) => {
							if (isRecaptchaInvisible) {
								grecaptcha.execute().then(() => {
									const respons = document.getElementsByClassName("g-recaptcha-response");
									for (let i = 0; i < length; i++) {
										respons[i].value = gToken;
									}
								});
							} else {
								grecaptcha.reset();
							}
						});

						if (!isRecaptchaInvisible) return;

						grecaptcha.execute().then(() => {
							const respons = document.getElementsByClassName("g-recaptcha-response");
							for (let i = 0; i < length; i++) {
								respons[i].value = gToken;
							}
						});
					});
					init = true;
				}
			};

			if (!init) {
				Nette.recaptcha(grecaptcha);
			}
		})(document, Nette, grecaptcha);
	};

	script.addEventListener("load", scriptLoaded, false);
};

document.addEventListener("click", initializeRecaptcha);
