<?php declare(strict_types = 1);

namespace TemplateDefault\DI;

use Core\DI\CompilerExtension;
use Nette;

class TemplateDefaultExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['TemplateDefault' => 'TemplateDefault\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->getMethod('initialize');
		$builder = $this->getContainerBuilder();

		$init->addBody('define(\'REUSABLE_DIR_TEMPLATE_DEFAULT\', \'' . __DIR__ . '/../Templates/Reusable\');');
		$init->addBody('TemplateDefault\Model\TemplateDefaultConfig::setParams($this->parameters[\'templateDefault\']);');
	}
}
