<?php declare(strict_types = 1);

namespace TemplateDefault\Model\Subscribers;

use Core\Model\Event\CreateFormEvent;
use Core\Model\Event\MailEvent;
use Core\Model\SystemConfig;
use Forms\FrontModule\Components\FormControl;
use Nette\Localization\Translator;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class FormControlSubscriber implements EventSubscriberInterface
{
	protected Translator $translator;

	public function __construct(Translator $translator)
	{
		$this->translator = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			FormControl::class . '::createInquiry' => 'inquiry',
		];
	}

	public function inquiry(CreateFormEvent $event): void
	{
		$form = &$event->form;
		$form->setAjax();
		

		$form->addText('name', 'tt.form.name')->setRequired();
		$form->addEmail('email', 'tt.form.email')->setRequired();
		$form->addPhone('phone', 'tt.form.phone')->setRequired()->setHtmlAttribute('placeholder', '');

		$form->addTextArea('message', 'tt.form.message')
			->setHtmlAttribute('placeholder', '')
			->setRequired();

		$form->addCheckBox('checkbox', 'front.form.checkbox')->setRequired();

		$form->addTurnstile('turnstile', 'front.form.turnstile', 'front.form.turnstile')->setTheme('light');

		$form->addSubmit('submit', 'front.submitForm');
	}

	public function beforeUserEmailToSubscribe(MailEvent $event): void
	{
		$mail   = $event->mail;
		$values = $event->data['values'] ?? [];

		$file = WWW_DIR . '/images/files/' . $values['file'] . '.pdf';
		if (file_exists($file))
			$mail->getMessage()->addAttachment($file);
	}
}
