<?php declare(strict_types = 1);

namespace Ulozenka\CronModule\Presenters;

use Core\Model\Countries;
use JetBrains\PhpStorm\NoReturn;
use Nette\DI\Attributes\Inject;
use Ulozenka\Model\UlozenkaParcels;

class DefaultPresenter extends BasePresenter
{
	#[Inject]
	public Countries $countriesService;

	#[Inject]
	public UlozenkaParcels $parcelService;

	public function actionParcelsByService(int $id, string $country): void
	{
		$data    = [];
		$country = $this->countriesService->get($country);

		foreach ($this->parcelService->getParcelsByService($id) as $k => $row) {
			if ($row->country === $country->getIso3166_1()) {
				$data[$k] = [
					'name' => $row->name,
				];
			}
		}

		$this->getPresenter()->sendJson($data);
	}
}
