<?php declare(strict_types = 1);

namespace Ulozenka\Model\Entities;

use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'ulozenka__parcel_number')]
#[ORM\Entity]
class UlozenkaParcelNumber
{
	#[ORM\Id]
	#[ORM\Column(type: Types::STRING, nullable: false)]
	public string $numberPackage;

	#[ORM\JoinColumn(name: 'parcel_order_id', referencedColumnName: 'order_id', nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: UlozenkaOrder::class, inversedBy: 'associatedNumberPackages')]
	protected UlozenkaOrder $parcelOrder;

	public function __construct(string $numberPackage, UlozenkaOrder $parcelOrder)
	{
		$this->numberPackage = $numberPackage;
		$this->parcelOrder   = $parcelOrder;
	}

	public function getNumberPackage(): string
	{
		return $this->numberPackage;
	}
}
